unit EngineImgScaleDialog01;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, EngineImgScale01;

type
  TFormScaleDialog = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    EditTrgW: TEdit;
    EditTrgH: TEdit;
    CbBoxTrgW: TComboBox;
    CbBoxTrgH: TComboBox;
    ImageProportional: TImage;
    CboBoxMhetod: TComboBox;
    BitBtnRun: TBitBtn;
    BitBtnCancel: TBitBtn;
    Label3: TLabel;
    EditSrcW: TEdit;
    Label4: TLabel;
    EditSrcH: TEdit;
    BitBtnUnDo: TBitBtn;
    ChkBoxProportional: TCheckBox;
    Label5: TLabel;
    procedure BitBtnCancelClick(Sender: TObject);
    procedure BitBtnRunClick(Sender: TObject);
    procedure ChkBoxProportionalClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CbBoxTrgHClick(Sender: TObject);
    procedure CbBoxTrgWClick(Sender: TObject);
    procedure BitBtnUnDoClick(Sender: TObject);
    procedure EditTrgWChange(Sender: TObject);
    procedure EditTrgHChange(Sender: TObject);
  private
    //  -     EditTrgW  EditTrgH
    procedure EditHWChangeOnOff (RqOn : boolean);
    //       
    procedure ShowPixNumb();
    //      
    procedure ShowNewHeight();
    //      
    procedure ShowNewWidth();
    //     
    procedure LoadNewWidth();
    //     
    procedure LoadNewHeight();
    //   
    procedure InitShowHeightWidth();
  public
    { Public declarations }
  end;

//   FormScaleDialog
var FormScaleDialog : TFormScaleDialog;

//  Image.     
//    FormScaleDialog
procedure SetImageSrcTrg (RqImgSrc, RqImgTrg : TImage);

implementation

{$R *.dfm}

var ImgSrc, ImgTrg : TImage;
var ImageScale     : TImageScale;
// ------------------------------------------------------------------------
// . , 
// ------------------------------------------------------------------------
//  Image.     
//    FormScaleDialog
procedure SetImageSrcTrg (RqImgSrc, RqImgTrg : TImage);
begin
  ImgSrc := RqImgSrc;
  ImgTrg := RqImgTrg;
end;
// ------------------------------------------------------------------------
// 
procedure TFormScaleDialog.FormCreate(Sender: TObject);
begin
  ImageScale := TImageScale.Create;
end;
// ------------------------------------------------------------------------
// 
procedure TFormScaleDialog.FormDestroy(Sender: TObject);
begin
  ImageScale.Free;
end;
// ------------------------------------------------------------------------
// , 
// ------------------------------------------------------------------------
//   
procedure TFormScaleDialog.BitBtnCancelClick(Sender: TObject);
begin
  Close;
end;
// ------------------------------------------------------------------------
//   
procedure TFormScaleDialog.BitBtnRunClick(Sender: TObject);
begin
  case CboBoxMhetod.ItemIndex of
    0 : ImageScale.RunScaleHW();
    1 : ShowMessage ('  ');
    2 : ShowMessage ('  ');
    else ImageScale.RunScaleHW();
  end;
  Close;
end;

// ------------------------------------------------------------------------
//   
// ------------------------------------------------------------------------
//  -     EditTrgW  EditTrgH
procedure TFormScaleDialog.EditHWChangeOnOff (RqOn : boolean);
begin
   if RqOn
   then begin
     EditTrgH.OnChange := EditTrgHChange;
     EditTrgW.OnChange := EditTrgWChange;
   end
   else begin
     EditTrgH.OnChange := nil;
     EditTrgW.OnChange := nil;
   end;
end;
// ------------------------------------------------------------------------
//       
procedure TFormScaleDialog.ShowPixNumb();
var SrcNum, TrgNum : Cardinal;
begin
    SrcNum := ImageScale.SrcWidth * ImageScale.SrcHeight;
    TrgNum := ImageScale.NewWidth * ImageScale.NewHeight;
    GroupBox1.Caption :=  '  : '
                          + IntToStr(TrgNum)
                          + ' (: '
                          + IntToStr(SrcNum)
                          + ')';
end;

// ------------------------------------------------------------------------
//      
procedure TFormScaleDialog.ShowNewHeight();
var Procent : single;
begin
   EditHWChangeOnOff(False);
   case CbBoxTrgH.ItemIndex of
   0 : begin //   
          EditTrgH.Text := IntToStr(ImageScale.NewHeight);
       end;
   1 : begin //   
          if ImageScale.SrcHeight > 0
          then Procent := ImageScale.NewHeight / ImageScale.SrcHeight
          else Procent := 0;
          EditTrgH.Text := format('%4.1f', [100 * Procent])
       end;
       else EditTrgH.Text := '';
   end;
   ShowPixNumb();
   EditHWChangeOnOff(True);
end;
// ------------------------------------------------------------------------
//      
procedure TFormScaleDialog.ShowNewWidth();
var Procent : single;
begin
   EditHWChangeOnOff(False);
   case CbBoxTrgW.ItemIndex of
   0 : begin //   
          EditTrgW.Text := IntToStr(ImageScale.NewWidth);
       end;
   1 : begin //   
          if ImageScale.SrcWidth > 0
          then Procent := ImageScale.NewWidth / ImageScale.SrcWidth
          else Procent := 0;
          EditTrgW.Text := format('%4.1f', [100 * Procent])
       end;
   end;
   ShowPixNumb();
   EditHWChangeOnOff(True);
end;
// ------------------------------------------------------------------------
procedure TFormScaleDialog.CbBoxTrgHClick(Sender: TObject);
begin
  //      
   ShowNewHeight();
end;
// ------------------------------------------------------------------------
procedure TFormScaleDialog.CbBoxTrgWClick(Sender: TObject);
begin
  //      
  ShowNewWidth();
end;
// ------------------------------------------------------------------------
//    
// ------------------------------------------------------------------------
//    TEdit     
//       .
function LoadFloatFromEdit (RqEdit : TEdit; var OutDouble : double) : boolean;
begin
    Result := False;             //  
    try
      OutDouble := StrToFloat(RqEdit.Text);
      RqEdit.Color := clWindow;  //   
      Result := True;            //  
    except
      //  .  :
      RqEdit.Color := RGB(255,200,200);
    end;
end;
// ------------------------------------------------------------------------
//     
procedure TFormScaleDialog.LoadNewWidth();
var SrcW, RqNew, Procent : double;
begin
   if LoadFloatFromEdit(EditTrgW, RqNew)
   then begin
       SrcW := ImageScale.NewWidth;
       //  
       if (SrcW > 0) and (RqNew > 0)
       then begin
          case CbBoxTrgW.ItemIndex of
          0 : begin  //   
                 if (RqNew <> SrcW)
                 then begin
                   if ChkBoxProportional.Checked
                   then begin
                      Procent := RqNew / ImageScale.SrcWidth;
                      ImageScale.Zoom := Procent;
                   end
                   else ImageScale.NewWidth := Round(RqNew);
                 end;
              end;
          1 : begin  //   
                 Procent :=  ImageScale.Zoom;
                 if RqNew <> (Procent * 100)
                 then begin
                    if ChkBoxProportional.Checked
                    then ImageScale.Zoom := RqNew / 100
                    else ImageScale.NewWidth := Round((RqNew / 100)
                                             * ImageScale.SrcWidth);
                 end;
              end;
          end;
          //      
          if ImageScale.CorrYes
          then begin
             ShowNewWidth();
             ShowNewHeight();
          end;
          //  
          if ChkBoxProportional.Checked then ShowNewHeight();
       end;
   end;
end;
// ------------------------------------------------------------------------
//   
procedure TFormScaleDialog.EditTrgWChange(Sender: TObject);
begin
   LoadNewWidth();
end;
// ------------------------------------------------------------------------
//     
procedure TFormScaleDialog.LoadNewHeight();
var TrgH, RqNew, Procent : double;
begin
   if LoadFloatFromEdit(EditTrgH, RqNew)
   then begin
       TrgH := ImageScale.NewHeight;
       //  
       if (TrgH > 0) and (RqNew > 0)
       then begin
          case CbBoxTrgH.ItemIndex of
          0 : begin  //   
                 if (RqNew <> TrgH)
                 then begin
                   if ChkBoxProportional.Checked
                   then begin
                      Procent := RqNew / ImageScale.SrcHeight;
                      ImageScale.Zoom := Procent;
                   end
                   else ImageScale.NewHeight := Round(RqNew);
                 end;
              end;
          1 : begin  //   
                 Procent :=  ImageScale.Zoom;
                 if RqNew <> (Procent * 100)
                 then begin
                    if ChkBoxProportional.Checked
                    then ImageScale.Zoom := RqNew / 100
                    else ImageScale.NewHeight := Round((RqNew / 100)
                                               * ImageScale.SrcHeight);
                 end;
              end;
          end;
          //      
          if ImageScale.CorrYes
          then begin
             ShowNewWidth();
             ShowNewHeight();
          end;
          //  
          if ChkBoxProportional.Checked then ShowNewWidth();
       end;
   end;
end;
// ------------------------------------------------------------------------
//   
procedure TFormScaleDialog.EditTrgHChange(Sender: TObject);
begin
   LoadNewHeight();
end;
// ------------------------------------------------------------------------
//  .-.  
procedure TFormScaleDialog.ChkBoxProportionalClick(Sender: TObject);
begin
   if ChkBoxProportional.Checked
   then ImageProportional.Visible := True
   else ImageProportional.Visible := False;
   ImageScale.Proportional := ChkBoxProportional.Checked;
end;
// ------------------------------------------------------------------------
//    
// ------------------------------------------------------------------------
//   
procedure TFormScaleDialog.InitShowHeightWidth();
begin
   ChkBoxProportional.Checked := True;
   ImageScale.Proportional := True;
   ImageScale.Zoom := 1;
   ShowNewHeight();
   ShowNewWidth();
end;
// ------------------------------------------------------------------------
//      
procedure TFormScaleDialog.BitBtnUnDoClick(Sender: TObject);
begin
   InitShowHeightWidth();
end;
// ------------------------------------------------------------------------
//      
//  
procedure TFormScaleDialog.FormShow(Sender: TObject);
begin
  if Assigned(ImgSrc) and Assigned(ImgTrg)
  then begin
    EditSrcW.Text := IntToStr(ImgSrc.Width);
    EditSrcH.Text := IntToStr(ImgSrc.Height);
    ImageScale.ImageSrc := ImgSrc;
    ImageScale.ImageTrg := ImgTrg;
    //   
    InitShowHeightWidth();
  end
  else begin
    EditSrcW.Text := '0';
    EditSrcH.Text := '0';
    ImageScale.ImageSrc := nil;
    ImageScale.ImageTrg := nil;
    MessageDlg('   Images.'
             + #13#10
             + '   ...',
                mtWarning, [mbOk], 0);
    Close;
  end;
end;









end.
